---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-next info

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **getRegistryの動作**: レジストリURL取得の実装を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-info.ts` - next infoコマンドの実装（608行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（349-361行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextInfoOptionsはverboseプロパティのみ | E-01 (14-16行目) | ○ |
| C-02 | TaskResult型はmessages, output, resultを持つ | E-01 (18-24行目) | ○ |
| C-03 | PlatformTaskScript型はOS別スクリプトをサポート | E-01 (28-53行目) | ○ |
| C-04 | getPackageVersionはrequireでpackage.jsonを読む | E-01 (55-61行目) | ○ |
| C-05 | getNextConfigはPHASE_INFOで設定を読み込む | E-01 (63-72行目) | ○ |
| C-06 | getBinaryVersionは--versionで実行、失敗時はexecSync | E-01 (78-91行目) | ○ |
| C-07 | npmレジストリからdist-tagsをfetch | E-01 (106行目) | ○ |
| C-08 | バージョン古さ判定をStalenessで行う | E-01 (115行目) | ○ |
| C-09 | NEXT_RSPACK時にnext-rspackバージョン表示 | E-01 (142-145行目) | ○ |
| C-10 | メモリ表示はMB単位（Math.ceil） | E-01 (152行目) | ○ |
| C-11 | Node.js診断レポートから機密情報を削除 | E-01 (347-350行目) | ○ |
| C-12 | next-swcのloadBindings / getTargetTriple使用 | E-01 (375-381行目) | ○ |
| C-13 | Linux: ldd、macOS: otool/dyld_info、Windows: dumpbin.exe | E-01 (475-529行目) | ○ |
| C-14 | 詳細モードはwin32/linux/darwinのみサポート | E-01 (258-267行目) | ○ |
| C-15 | 各タスクの結果はpass/fail/skipped | E-01 (23行目) | ○ |
| C-16 | WSL/Docker/CI検出を実施 | E-01 (282-293行目) | ○ |
| C-17 | fetchエラー時は警告表示してスキップ | E-01 (120-133行目) | ○ |
| C-18 | getRegistryでnpmレジストリURLを取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- getRegistry関数の実装詳細は`packages/next/src/lib/helpers/get-registry.ts`にあるが、内容を確認していない
  - 候補：get-registry.tsの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: npmレジストリURLの決定ロジックはカスタムレジストリ使用時に影響する可能性がある
- 0: Node.js診断レポートの機密情報削除が十分かの確認

## 6) レビュアーチェックリスト（最小）
- [ ] 出力される環境情報の項目が漏れなく記載されているか
- [ ] --verboseモードの5つのタスクが正確に記載されているか
- [ ] OS別の共有ライブラリチェックツールが正しいか
- [ ] 機密情報削除の対象フィールドが正確か
